#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

char* cpu(void)
{
	unsigned int total;
	
	float user;
	float nice;
	float system;
	float idle;

	char cpu[21];
	char text[201];

	FILE *fp;

	fp = fopen("/proc/stat", "r");
	while (fgets(text, 200, fp))
	{
		if (strstr(text, "cpu"))
		{
			sscanf(text, "%s %f %f %f %f", cpu, &user, &nice, &system, &idle);
		}
	}
	fclose(fp);

	total = (user + nice + system + idle);
	user = (user / total) * 100;
	nice = (nice / total) * 100;
	system = (system / total) * 100;
	idle = (idle / total) * 100;

	snprintf(cpu, 21, "%4.2f %4.2f %3.2f %4.2f", user, nice, system, idle);

	return(cpu);
}
