//
// BATCH.CPP : Dialogroutinen                  (c) in 1997 by FUTUREWARE 2001
//

#ifndef _DIALOG_H
#define _DIALOG_H

#ifndef WURST
  #define DIALOG_TEXT
  //#define DEBUG

  #include <time.h>
  #include <stdarg.h>
  #include <stdio.h>
#ifndef __linux
  #include <mem.h>
  #include <process.h>
  #include <malloc.h>
#endif
  #include "./gfx.h"

  void Occur(S2 Occurance) {}
#endif

#include "dialog.h"

int Line=0;

#ifndef DIALOG_TEXT
void Show_Graphic_Menu()
{
}
#endif

void Delete_Menu(U2 j)
{
  U2 i=0;
  if (j < nTexte[Priv])
    memmove(Menutext[Priv][j].A,Menutext[Priv][j+1].A,sizeof(Menutexttyp)*(nTexte[Priv]-j-1));
  nTexte[Priv]--;
  while(i<nItems[Priv])
  {
    if (j<Menuitem[Priv][i].Menutext)
    {
      Menuitem[Priv][i].Menutext--;
      i++;
    }
    else
    {
      if (j==Menuitem[Priv][i].Menutext)
      {
        memmove(Menuitem[Priv][i].A,Menuitem[Priv][i+1].A,sizeof(Menuitemtyp)*(nItems[Priv]-i-1));
        nItems[Priv]--;
      }
      else
        i++;
    }
  }
}

void Insert_Items()
{
  U1 InsertPoint=0;
  U2 Pos=0;
  U2 Try=0;
  U2 i;
  #define TX Menutext[Priv][0].Text
  for (i=0;i<nItems[Priv];i++) Menuitem[Priv][i].Menutext++;
  while (*(TX+Pos))
  {
    if ((Try=strlen(TX+Pos))>50)
    {
      Try=49;
      while(Try && *(TX+Pos+Try)!=' ')
        Try--;
      if (!Try) Fehler("Text-Fehler!");
    }
    memmove(Menuitem[Priv][InsertPoint+1].A,Menuitem[Priv][InsertPoint].A,
      sizeof(Menuitemtyp)*(nItems[Priv]-InsertPoint));
    memset(Menuitem[Priv][InsertPoint].A,0,sizeof(Menuitemtyp));
    nItems[Priv]++;
    memcpy(Menuitem[Priv][InsertPoint].Text,Menutext[Priv][0].Text+Pos,Try);
    Pos+=Try;
    InsertPoint++;
  }
  #undef TX
};

void Interpret_Line(S1 *Dest,S1 *Source,TYP Array[])
{
  int Tiefe=0;
  TYP Value;
  S1 *Temp;
  while(*Source!=0)
  {
    if (*Source!='[') *(Dest++)= *(Source++);
    else
    {
      Tiefe=1;
      Temp=Source+1;
      while(Tiefe>0)
      {
        if (*Temp=='[') Tiefe++;
        if (*Temp==']') Tiefe--;
        Temp++;
      }
      Value=Evaluate(Source+1,Temp-Source-2,Array);
      if (Value>=0 && Value<256)
        sprintf(Dest,"%d",Array[Value]);
      else
      {
        if(Value<0) Value=-Value;
//        strcpy(Dest,Text[Value]);
      }
      Dest+=strlen(Dest);
      Source=Temp;
    }
  }
  *Dest=0;
}

void Speek(S1 Person,S1 *Text,TYP Array[])
{
  int Ende=0; Ende=Ende;
  Interpret_Line(Messagebuffer, Text,Array);
  #ifdef Update
    Update();
  #endif
  #ifdef DIALOG_TEXT
  switch(Person)
  {
    case S_Leni:   printf("Leni: ");break;
    case S_Kunde:  printf("Kunde: ");break;
    case S_Fehler: printf("Fehler: ");break;
    case S_System: printf("System: ");break;
    case S_Stat:   printf("Stat: ");break;
  }
  printf("%s\n",Messagebuffer);
  #else
  End_Clock=clock()+Clock*(strlen(Messagebuffer)/10+2);
  memcpy(GfxScreen+320*160,Puffer+320*160,320*40);

  switch(Person)
  {
    case S_Leni:  WriteString(18,315,164,Messagebuffer,13,0);break;
    case S_Kunde: WriteString(18,315,164,Messagebuffer,1 ,0);break;
    case S_Fehler:WriteString(18,315,164,Messagebuffer,2 ,0);break;
    case S_System:WriteString(18,315,164,Messagebuffer,2 ,0);break;
    case S_Stat:  WriteString(18,315,164,Messagebuffer,2 ,0);break;
  };
  Ende=0;

  while((clock()<End_Clock) && !Ende)
  {
    if (Person==S_Kunde)
      Show_Background(0);
    End_Timer=clock()+(Clock*rnd(100,300))/1000;
    while (clock()<End_Timer && !Ende)
      if (kbhit() || mouseclick())
        Ende=1;
  }
  Show_Background(1);
  End_Timer=clock()+Clock*rnd(1,2);
  while (clock()<End_Timer && !Ende)
    if (kbhit() || mouseclick())
      Ende=1;
  while(kbhit()) getch();
  #endif
}

int Do_Menu(TYP Array[])
{
  S1 Ende=0,Eingabe;
  char Zeile[20];
  Start=0;
  sprintf(Zeile,"%d",Line);

  if (nItems[Priv]<1)
    #ifndef DEBUG
      return (0);
    #else
      Fehler("Keine Auswahlmglichkeiten/Dateien in Zeile %s gefunden!",Zeile);
    #endif

  if (nTexte[Priv]==1) return (0);
  #ifdef DIALOG_TEXT

  S1 Text[100];
  U2 i;
  for (i=0;i<nItems[Priv];i++)
  {
    sprintf(Text,"%c: %s",i+'1',Menuitem[Priv][i].Text);
    Speek(S_Menu,Text,Array);
  }

  while(!Ende)
  {
    Eingabe=getch()-'1';
    if (Eingabe>=0 && Eingabe<nItems[Priv]) Ende=1;
  }
  printf("\n");

  #else

  Update();
  while (!Ende)//Alle Maustasten
  {
    Click=maus_input();
    switch (Click)
    {
      case 42:
        if (Start)
        {
          Start--;
          Update();
        }
      break;
      case 43:
        if ((Start+G_Menu_Count)<nItems[Priv])
        {
          Start++;
          Update();
        }
      break;
      case 44:
        Eingabe=Start+0;
        Ende=1;
      break;
      case 45:
        Eingabe=Start+1;
        Ende=1;
      break;
      case 46:
        Eingabe=Start+2;
        Ende=1;
      break;
      case 47:
        Eingabe=Start+3;
        Ende=1;
      break;
    }
  }
  maus_hide();
  #endif
  Array=Array;
  return (Menuitem[Priv][Eingabe].Menutext);
}

TYP LeeresArray[1000];

S2 Dialog(char *Filename, TYP Array[])
{
  S1 Person_Name[20];
  S2 ret=0;
  S4 Flag=0,i=0,j=0,Lines=0,Ende=0;
  long Size=0;
  U1 Recognized=0;
  S1 Fast_Del,Label[Labellength];
  Priv=1;
  Line=0;
  Set_Palette(24,25,&Pfeilgrafik[6],2);
  Set_Palette(26,27,&Pfeilgrafik[6],2);
  if(!fexist(Filename)) Fehler("Dialog nicht gefunden!");
  Batchfile=floadfile(Filename,"rt",&Size);
  if (Batchfile==NULL) return(0);
  Batch[j++]=Batchfile;
  for (i=0;i<Size;i++)
  {
    if (Batchfile[i]=='\r' && Batchfile[i+1]=='\n')
    {
      if(j>=nLines) Fehler("Zuviele Zeilen im Dialog!");
      Batchfile[i]=0;Batchfile[i+1]=0;
      Batch[j++]=Batchfile+i+2;
    };
    if (Batchfile[i]=='\n')
    {
      if(j>=nLines) Fehler("Zuviele Zeilen im Dialog!");
      Batchfile[i]=0;
      Batch[j++]=Batchfile+i+1;
    };
  }
  Lines=j-1;
  for (i=0;i<NLISTS;i++)
  {
    nItems[i]=0;
    nTexte[i]=0;
  }

  memset(Person_Name,0,sizeof(Person_Name));
  memcpy(Person_Name,Filename,strcspn(Filename,".\n"));

  #ifndef WURST
  // Testen ob alle Labels richtig angesprungen werden knnen
  for(Line=0;Line<Lines;Line++)
  {
    Recognized=0;
    memset(Label,0,sizeof(Label));
    strcpy(Label,":");
    if (!memicmp(Batch[Line],"sprung "  ,7))
    {
      strcat(Label,&Batch[Line][7]);
    }
    if (!memicmp(Batch[Line],"Neu "   ,4))
    {
      memcpy(Label+1,Batch[Line]+4,strcspn(Batch[Line]+4," *:,\n"));
    }
    #ifdef DEBUG
    if(Label[1])
    {
      int Counter=0;
      for (i=0;i<Lines;i++)
        if (!stricmp(Batch[i],Label))
          Counter++;
      if(!Counter) printf("Sprungziel %s in Zeile %d wurde nicht gefunden: \n %s\n",Label,Line+1,Batch[Line]);
      if(Counter>1)printf("Sprungziel %s in Zeile %d wurde %d mal gefunden: \n %s\n",Label,Line+1,Counter,Batch[Line]);
    }
    if(Batch[Line][0]==':')
    {
      int Counter=0;
      for (i=0;i<Lines;i++)
      {
        if (!memicmp(Batch[i],"Neu "   ,4)) if(!memicmp(Batch[Line]+1,Batch[i]+4,strcspn(Batch[i]+4," *:,\n"))) Counter++;
        if (!memicmp(Batch[i],"sprung "  ,7)) if(!stricmp(Batch[Line]+1,Batch[i]+7)) Counter++;
      }
      if(!Counter) printf("Sprungziel %s in Zeile %d wird nicht angesprungen: \n",Batch[Line],Line);
    }
    #endif

    if (!memicmp(Batch[Line],"ende"   ,4)) Eval(Batch[Line]+4,LeeresArray);
    if (!memicmp(Batch[Line],"liste"  ,5)) Eval(Batch[Line]+5,LeeresArray);
    if (!memicmp(Batch[Line],"aktion" ,6)) Eval(Batch[Line]+7,LeeresArray);
    if (!memicmp(Batch[Line],"bild"   ,4)) Eval(Batch[Line]+4,LeeresArray);
    if (!memicmp(Batch[Line],"film"   ,4)) Eval(Batch[Line]+4,LeeresArray);
    if (!memicmp(Batch[Line],"sprung ",7)) Interpret_Line(Label+1,Batch[Line]+7,LeeresArray);
    if (!memicmp(Batch[Line],"rechne ",7)) Eval(Batch[Line]+7,LeeresArray);
    if (!memicmp(Batch[Line],"wenn "  ,5)) Eval(Batch[Line]+5,LeeresArray);

    if (!memicmp(Batch[Line],"ende"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"liste"   ,5)) Recognized=1;
    if (!memicmp(Batch[Line],"private" ,6)) Recognized=1;
    if (!memicmp(Batch[Line],"public"  ,6)) Recognized=1;
    if (!memicmp(Batch[Line],"lschen ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"LSCHEN ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"lschen ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"LSCHEN ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"kunde: " ,7)) Recognized=1;
    if (!memicmp(Batch[Line],"tel: "   ,5)) Recognized=1;
    if (!memicmp(Batch[Line],"system: ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"fehler: ",8)) Recognized=1;
    if (!memicmp(Batch[Line],"leni: "  ,6)) Recognized=1;
    if (!memicmp(Batch[Line],"aktion"  ,6)) Recognized=1;
    if (!memicmp(Batch[Line],"bild"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"film"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"sprung " ,7)) Recognized=1;
    if (!memicmp(Batch[Line],"Neu "    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"men"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"MEN"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"men"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"MEN"    ,4)) Recognized=1;
    if (!memicmp(Batch[Line],"wenn "   ,5)) Recognized=1;
    if (!memicmp(Batch[Line],"rechne " ,7)) Recognized=1;
    if (!memicmp(Batch[Line],"//"      ,2)) Recognized=1;
    if (!memicmp(Batch[Line],"*"       ,1)) Recognized=1;
    if (!memicmp(Batch[Line],";"       ,1)) Recognized=1;
    if (!memicmp(Batch[Line],":"       ,1)) Recognized=1;
    if (!memicmp(Batch[Line],"\n"      ,1)) Recognized=1;
    if (!strlen(Batch[Line])) Recognized=1;
    if (!Recognized) 
    {
      printf("Warnung: Zeile %d nicht erkannt: ",Line);
      printf("\"%s\"\n",Batch[Line]);
    }
  }
  #endif
  Ende=0; Line=0;
  while (!Ende)
  {
    #ifdef DEBUG
      printf("\nRun: %s\n",Batch[Line]);
    #endif
    if (!memicmp(Batch[Line],"ende" ,4)) {Ende=1;ret=Eval(Batch[Line]+4,Array);}
    if (!memicmp(Batch[Line],"liste" ,5)) Priv=minmax(0,Eval(Batch[Line]+5,Array),NLISTS-1);
    if (!memicmp(Batch[Line],"private" ,6)) Priv=0;
    if (!memicmp(Batch[Line],"public" ,6)) Priv=1;
    if (!memicmp(Batch[Line],"lschen ",8)||!memicmp(Batch[Line],"LSCHEN ",8)||!memicmp(Batch[Line],"lschen ",8)||!memicmp(Batch[Line],"LSCHEN ",8))
    {
      if(!stricmp("*",Batch[Line]+8))
      {
        nItems[Priv]=0;
        nTexte[Priv]=0;
      }
      for (j=0;j<nTexte[Priv];j++)
        if (!stricmp(Menutext[Priv][j].Label+1,Batch[Line]+8))
          Delete_Menu(j);
    }
    if (!memicmp(Batch[Line],"kunde: ",7)) Speek(S_Kunde,&Batch[Line][7],Array);
    if (!memicmp(Batch[Line],"tel: ",5))   Speek(S_Kunde,&Batch[Line][5],Array);
    if (!memicmp(Batch[Line],"system: ",8))Speek(S_System,&Batch[Line][8],Array);
    if (!memicmp(Batch[Line],"fehler: ",8))Speek(S_Fehler,&Batch[Line][8],Array);
    if (!memicmp(Batch[Line],"leni: ",6))  Speek(S_Leni,&Batch[Line][6],Array);
    if (!memicmp(Batch[Line],"aktion",6))
    {
      #ifdef DEBUG
        strcpy(Label,"Aktion wird ausgefhrt: ");strcat(Label,Batch[Line]+7);
        Speek(S_Stat,Label,Array);
      #endif
      Flag=Eval(Batch[Line]+7,Array);
      if (Flag) Occur(Flag);
    }
    if (!memicmp(Batch[Line],"bild",4))
    {
      #ifndef WURST
        sprintf(Label,"Bild wird gezeigt: %s%d.dat",Person_Name,Eval(Batch[Line]+4,Array));
        Speek(S_Stat,Label,Array);
      #else
      U4 Anzahl=Picture_Size;
      sprintf(Label,"%s%d.dat",Person_Name,Eval(Batch[Line]+4,Array));
      if (fexist(Label))
      {
        Get_Palette(0,255,Puffer+Screen_Size);
        memcpy(Screen_Puffer,GfxScreen,Screen_Size);
        Hilfe_Situation=Situation;
        Bereich=0;
        fload(Label,"rb",Anzahl,(U1*)GfxScreen,0);
        Set_Palette(0,255,(U1*)GfxScreen+Puffer_Size,0);

        WriteString(75,310,191,"Taste drcken zum fortsetzen",1,0);
        while(kbhit()||mouseclick()) if(kbhit()) getch();
        while(!mouseclick() && !kbhit());
        while(kbhit())getch();
        Situation=Hilfe_Situation;
        memcpy(GfxScreen,Screen_Puffer,Screen_Size);
        Set_Palette(0,255,Puffer+Screen_Size,0);
      }
      #endif
    }
    if (!memicmp(Batch[Line],"film",4))
    {
      Recognized=1;
      #ifndef WURST
        sprintf(Label,"Film wird gezeigt: %s%d.dat",Person_Name,Eval(Batch[Line]+4,Array));
        Speek(S_Stat,Label,Array);
      #else
      sprintf(Label,"%s%d.dat",Person_Name,Eval(Batch[Line]+4,Array));
      if (fexist(Label))
      {
        Get_Palette(0,255,Puffer+Screen_Size);
        memcpy(Screen_Puffer,GfxScreen,Screen_Size);
        Bereich=0;
        Play_Dat(Label,FColor^FKeyboard^FDirectory);
        memcpy(GfxScreen,Screen_Puffer,Screen_Size);
        Set_Palette(0,255,Puffer+Screen_Size,0);
      }
      #endif
    }
    if (!memicmp(Batch[Line],"sprung "  ,7))
    {
      strcpy(Label,":");
      Interpret_Line(Label+1,Batch[Line]+7,Array);
      for (i=0;i<Lines;i++) if (!stricmp(Batch[i],Label)) Line=i;
    }
    if (!memicmp(Batch[Line],"Neu "   ,4))
    {
      Flag=1;
      memset(Label,0,sizeof(Label));
      strcpy(Label,":");
      memcpy(Label+1,Batch[Line]+4,strcspn(Batch[Line]+4," *:,\n"));
      for (j=0;j<nTexte[Priv];j++)
        if (!stricmp(Menutext[Priv][j].Label,Label))
          Flag=0;
      if (Flag)
      {
        memmove(Menutext[Priv][1].A,Menutext[Priv][0].A,sizeof(Menutexttyp)*(nMenutexte-1));
        Fast_Del=*(strchr(Batch[Line]+4,',')+1);
        Fast_Del=(*(strchr(Batch[Line]+4,',')+1)=='')?1:0;
        strcpy(Menutext[Priv][0].Text,1+Fast_Del+strchr(Batch[Line]+4,','));
        Menutext[Priv][0].Fast_Delete=Fast_Del;
        memset(Menutext[Priv][0].Label,0,Labellength);
        Menutext[Priv][0].Label[0]=':';
        memcpy(Menutext[Priv][0].Label+1,Batch[Line]+4,strcspn(Batch[Line]+4," *:,\n"));
        nTexte[Priv]++;
        Insert_Items();
      }
    }
    if (!memicmp(Batch[Line],"men"   ,4)||!memicmp(Batch[Line],"MEN"   ,4)||!memicmp(Batch[Line],"men",4)||!memicmp(Batch[Line],"MEN",4)||!memicmp(Batch[Line],"menu",4))
    {
      int Eingabe;
      Eingabe=Do_Menu(Array);
      Speek(S_Leni,Menutext[Priv][Eingabe].Text,Array);

      Interpret_Line(Label,Menutext[Priv][Eingabe].Label,Array);
      for (i=0;i<Lines;i++)
        if (!stricmp(Batch[i],Label))
          Line=i;
      if (!Priv)
      {
        nItems[Priv]=0;
        nTexte[Priv]=0;
      }
      else
      {
        Delete_Menu(Eingabe);
        for (j=0;j<nTexte[Priv];j++)
          if (Menutext[Priv][j].Fast_Delete)
            Delete_Menu(j);
      }
    }
    if (!memicmp(Batch[Line],"rechne " ,7))
    {
      Eval(Batch[Line]+7,Array);
    }
    if (!memicmp(Batch[Line],"wenn "   ,5))
    {
      #ifdef DEBUG
        printf("%s->%d\n",Batch[Line]+5,Eval(Batch[Line]+5,Array));
      #endif
      if (!Eval(Batch[Line]+5,Array)) Line++;
    }
    Line++;
    if (Line>=Lines) Ende=1;
  };
  if(Batchfile!=NULL) delete Batchfile;
  Batchfile=NULL;
  return (ret);
}
#endif


#ifndef WURST


TYP Feld[256];
S1 File[50]="_";
FILE *Handle=NULL;
int i;
S1 Daten[100];

void Load_Feld()
{
  Handle=fopen(File,"rt");
  if (!Handle) return;
  fscanf(Handle,"Ende\n");
  for(i=0;i<256;i++)
  {
    fscanf(Handle,"%d\n",&Feld[i]);
  }
  fclose(Handle);
}

void Save_Feld()
{
  Handle=fopen(File,"wt");
  if (!Handle) return;
  fprintf(Handle,"Ende\n");
  for(i=0;i<256;i++)
  {
    fprintf(Handle,"%d\n",Feld[i]);
  }
  fclose(Handle);
}

int main(short argc,char *argv[])
{
  int i=0;
  Priv=1;
  char *Filename=argv[1];
  if(!fexist(Filename))
  {
    nItems[Priv]=GetFileList("./",".bat",Menuitem[Priv][0].Text,sizeof(Menuitemtyp),nMenuitems);
    for (i=0;i<nItems[Priv];i++)
      Menuitem[Priv][i].Menutext=i;
    i=Do_Menu(Feld);
    Filename=Menuitem[Priv][i].Text;
  }
  strcpy(File+1,Filename);
  Load_Feld();
//  printf("Datum: %d\n",Datum());
  srand(Datum());
  Dialog(Filename,Feld);
  Save_Feld();
  printf("[100 bis 109]: ");
  for (i=100;i<110;i++)
    printf("%3d ",Feld[i]);
  printf("\n");
  return 0;
}

#endif
